<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia; // Import Inertia
use App\Models\ProductCategory; // Import the ProductCategory model
use App\Http\Requests\ProductCategoryStoreRequest; // Import the ProductCategoryStoreRequest
use App\Http\Requests\ProductCategoryUpdateRequest; // Import the ProductCategoryUpdateRequest
use Illuminate\Support\Str; // Import Str for UUID generation

class ProductCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $productCategories = ProductCategory::latest()->paginate(10);
        return Inertia::render('Admin/Products/Categories/Index', [
            'productCategories' => $productCategories,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render('Admin/Products/Categories/Create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ProductCategoryStoreRequest $request)
    {
        $validated = $request->validated();

        $productCategory = new ProductCategory();
        $productCategory->id = Str::uuid(); // Generate UUID for the product category
        $productCategory->name = $validated['name'];
        $productCategory->description = $validated['description'] ?? null;
        $productCategory->save();

        return redirect()->route('admin.product-categories.index')->with('success', 'Product category created successfully.');
    }

    /**
     * Display the specified resource. The route model binding will automatically fetch the category.
     */
    public function show(ProductCategory $productCategory)
    {
        return Inertia::render('Admin/Products/Categories/Show', [
            'productCategory' => $productCategory,
        ]);
    }

    /**
     * Show the form for editing the specified resource. The route model binding will automatically fetch the category.
     */
    public function edit(ProductCategory $productCategory)
    {
        return Inertia::render('Admin/Products/Categories/Edit', [
            'productCategory' => $productCategory,
        ]);
    }

    /**
     * Update the specified resource in storage. The route model binding will automatically fetch the category.
     */
    public function update(ProductCategoryUpdateRequest $request, ProductCategory $productCategory)
    {
        $validated = $request->validated();

        $productCategory->name = $validated['name'];
        $productCategory->description = $validated['description'] ?? null;
        $productCategory->save();

        return redirect()->route('admin.product-categories.index')->with('success', 'Product category updated successfully.');
    }

    /**
     * Remove the specified resource from storage. The route model binding will automatically fetch the category.
     */
    public function destroy(ProductCategory $productCategory)
    {
        $productCategory->delete();

        return redirect()->route('admin.product-categories.index')->with('success', 'Product category deleted successfully.');
    }
}
