<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SchoolService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class SchoolServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $schoolServices = SchoolService::latest()->paginate(10);
        return Inertia::render('Admin/SchoolServices/Index', ['schoolServices' => $schoolServices]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return Inertia::render('Admin/SchoolServices/Create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'type' => 'required|string|in:free,premium',
            'images' => 'nullable|array',
            // Add validation for image files if you handle uploads
        ]);

        SchoolService::create($request->all());

        return redirect()->route('admin.school-services.index')->with('success', 'School Service created successfully.');
    }

    /**
     * Display the specified resource.
     */
    public function show(SchoolService $schoolService)
    {
        // Not typically used in this kind of admin panel, but can be implemented if needed.
        return redirect()->route('admin.school-services.edit', $schoolService);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(SchoolService $schoolService)
    {
        return Inertia::render('Admin/SchoolServices/Edit', ['schoolService' => $schoolService]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, SchoolService $schoolService)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'nullable|string',
            'type' => 'required|string|in:free,premium',
            'images' => 'nullable|array',
        ]);

        $schoolService->update($request->all());

        return redirect()->route('admin.school-services.index')->with('success', 'School Service updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(SchoolService $schoolService)
    {
        $schoolService->delete();

        return redirect()->route('admin.school-services.index')->with('success', 'School Service deleted successfully.');
    }
}