<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use Illuminate\Http\Request;
use Inertia\Inertia;

class CoreValuesController extends Controller
{
    public function index()
    {
        $setting = Setting::firstOrCreate([]);
        return Inertia::render('Admin/Settings/CoreValues', [
            'setting' => $setting
        ]);
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'innovation' => 'required|string',
            'teamwork' => 'required|string',
            'growth' => 'required|string',
            'excellence' => 'required|string',
            'speed' => 'required|string',
            'integrity' => 'required|string',
            'mission' => 'nullable|string',
            'vision' => 'nullable|string',
        ]);

        $setting = Setting::first();
        $setting->update($validated);

        return redirect()->route('admin.settings.core-values.index');
    }
}
