<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use Inertia\Inertia;
use App\Models\Slider;
use App\Models\Service;
use App\Models\Portfolio;
use App\Models\Team;

class DashboardController extends Controller
{
    public function index()
    {
        $sliderCount = Slider::count();
        $serviceCount = Service::count();
        $portfolioCount = Portfolio::count();
        $teamCount = Team::count();

        return Inertia::render('Dashboard', [
            'sliderCount' => $sliderCount,
            'serviceCount' => $serviceCount,
            'portfolioCount' => $portfolioCount,
            'teamCount' => $teamCount,
        ]);
    }
}
