<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Services\PaypalService;
use Illuminate\Http\Request;

class PaypalController extends Controller
{
    protected $paypalService;

    public function __construct(PaypalService $paypalService)
    {
        $this->paypalService = $paypalService;
    }

    public function initiate(Request $request)
    {
        $order = Order::findOrFail($request->order_id);
        return $this->paypalService->initiatePayment($order);
    }
}
