<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Setting;
use App\Models\Portfolio;

class PortfolioPageController extends Controller
{
    public function index()
    {
        $setting = Setting::firstOrCreate([]);
        $portfolios = Portfolio::orderBy('order')->get();
        return Inertia::render('Portfolio', [
            'setting' => $setting,
            'portfolios' => $portfolios,
        ]);
    }
}
