<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Setting;
use Illuminate\Support\Facades\Mail;
use App\Mail\QuoteRequestMail;

class QuotePageController extends Controller
{
    public function create()
    {
        $setting = Setting::firstOrCreate([]);
        return Inertia::render('Quote', [
            'setting' => $setting,
        ]);
    }

    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'phone' => 'nullable|string|max:255',
            'service' => 'nullable|string|max:255',
            'message' => 'required|string',
        ]);

        // Send email notification
        Mail::to(config('mail.from.address'))->send(new QuoteRequestMail($validatedData));

        return redirect()->back()->with('success', 'Your quote request has been sent successfully!');
    }
}
