<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Setting;
use App\Models\Service;

class ServicePageController extends Controller
{
    public function index()
    {
        $setting = Setting::firstOrCreate([]);
        $services = Service::orderBy('order')->get();
        return Inertia::render('Services', [
            'setting' => $setting,
            'services' => $services,
        ]);
    }
}
