<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Setting;
use App\Models\Team;

class TeamPageController extends Controller
{
    public function index()
    {
        $setting = Setting::firstOrCreate([]);
        $teams = Team::orderBy('order')->get();
        return Inertia::render('Team', [
            'setting' => $setting,
            'teams' => $teams,
        ]);
    }
}
