<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Http\Requests\EventBookingStoreRequest;
use App\Models\Event;
use Illuminate\Http\Request;

use Inertia\Inertia;
use App\Models\EventBooking;
use App\Models\EventBookingDetail;
use Illuminate\Support\Facades\Auth;

class EventBookingController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $user = Auth::user();

        $eventBookings = EventBookingDetail::where('user_id', $user->id)
                                    ->with('event')
                                    ->latest()
                                    ->paginate(10);

        $eventBookings->getCollection()->transform(function ($eventBooking) {
            return [
                'id' => $eventBooking->id,
                'event_name' => $eventBooking->event->title,
                'booking_date' => $eventBooking->created_at->format('Y-m-d'),
                'quantity' => $eventBooking->quantity,
                'total_price' => $eventBooking->total_price,
                'status' => $eventBooking->status,
            ];
        });

        return Inertia::render('User/EventBookings/Index', [
            'eventBookings' => $eventBookings,
        ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(EventBookingStoreRequest $request)
    {
        $user = Auth::user();
        $event = Event::findOrFail($request->event_id);

        EventBooking::create([
            'event_id' => $event->id,
            'user_id' => $user->id,
            'quantity' => $request->attendees,
            'total_price' => $event->price * $request->attendees,
            'status' => 'confirmed',
        ]);

        return redirect()->back()->with('success', 'Event booked successfully!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
