<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\EventBookingDetail;
use App\Models\SchoolServiceBookingDetail;

class Booking extends Model
{
    use HasFactory, HasUuids;

    protected $fillable = [
        'user_id',
        'doctor_id',
        'bookable_id',
        'bookable_type',
        'status',
        'booking_date',
        'notes',
        'price',
        'quantity',
        'reference_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function doctor()
    {
        return $this->belongsTo(User::class, 'doctor_id');
    }

    public function bookable()
    {
        return $this->morphTo();
    }

    public function serviceBookingDetail()
    {
        return $this->hasOne(ServiceBookingDetail::class);
    }

    public function eventBookingDetail()
    {
        return $this->hasOne(EventBookingDetail::class);
    }

    public function schoolServiceBookingDetail()
    {
        return $this->hasOne(SchoolServiceBookingDetail::class);
    }
}
