<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Relations\BelongsTo; // Import BelongsTo
use App\Models\User; // Import the User model

class SchoolService extends Model
{
    use HasFactory, HasUuids;

    
    protected static function boot()
    {
        parent::boot();
        
        static::creating(function ($service) {
            $service->external_id = uniqid('srv_');
        });
    }
    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     * 
     */
    protected $fillable = [
        'name',
        'description',
        'type',
        'images',
        'image_urls',
        'price', // Add price to fillable attributes
        'start_date',
        'duration',
        'location',
        'instructor_id',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'images' => 'array',
        'image_urls' => 'array',
        'price' => 'decimal:2', // Cast price to decimal
        'start_date' => 'date',
    ];

    /**
     * Get the instructor that owns the school service.
     */
    public function instructor(): BelongsTo
    {
        return $this->belongsTo(User::class, 'instructor_id');
    }

    /**
     * Get all of the school service's order items.
     */
    public function orderItems(): MorphMany
    {
        return $this->morphMany(OrderItem::class, 'item');
    }

    public function bookings()
    {
        return $this->morphMany(Booking::class, 'bookable');
    }
}
    