<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Team extends Model
{
    use HasFactory, HasUuids;

    protected $fillable = [
        'name',
        'position',
        'image_path',
        'description',
        'facebook_link',
        'twitter_link',
        'linkedin_link',
        'order',
    ];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array
     */
    protected $appends = ['image_url'];

    /**
     * Get the URL of the team member's image.
     *
     * @return string
     */
    public function getImageUrlAttribute()
    {
        if ($this->image_path) {
            return 'storage/' . $this->image_path;
        }
        return 'https://via.placeholder.com/150'; // Placeholder image
    }
}
