<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\Order; // Import the Order model

class NewOrderNotification extends Notification
{
    use Queueable;

    protected $order;

    /**
     * Create a new notification instance.
     */
    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database']; // Store notification in the database
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
                    ->line('A new order has been placed!')
                    ->action('View Order', url('/admin/orders/' . $this->order->id))
                    ->line('Order ID: ' . $this->order->id)
                    ->line('Total Amount: $' . $this->order->total_amount);
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'order_id' => $this->order->id,
            'total_amount' => $this->order->total_amount,
            'customer_name' => $this->order->user->name ?? 'Guest',
            'message' => 'A new order (ID: ' . $this->order->id . ') has been placed by ' . ($this->order->user->name ?? 'Guest') . ' for $' . $this->order->total_amount . '.',
        ];
    }
}