<?php

namespace App\Services;

interface PaymentService
{
    /**
     * Initialize a payment with the given data.
     *
     * @param array $data
     * @return array
     */
    public function initializePayment(array $data): array;

    /**
     * Verify a payment using the given reference or transaction ID.
     *
     * @param string $reference
     * @return array
     */
    public function verifyPayment(string $reference): array;
}