<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

class ProductFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'id' => Str::uuid(),
            'external_id' => Str::uuid(),
            'name' => $this->faker->name(),
            'price' => $this->faker->randomFloat(2, 10, 100),
            'description' => $this->faker->text(),
        ];
    }
}
