<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('school_services', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->uuid('external_id')->unique();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('type')->default('free'); // e.g., 'free', 'premium'
            $table->json('images')->nullable();
            $table->json('image_urls')->nullable();
            $table->date('start_date')->nullable();
            $table->string('duration')->nullable();
            $table->string('location')->nullable();
            $table->decimal('price', 10, 2)->default(0.00);
            $table->foreignUuid('instructor_id')->constrained('users')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('school_services');
    }
};