import React, { useState } from 'react';
import EventBookingModal from '@/Components/EventBookingModal';
import { motion } from 'framer-motion';
import { CalendarIcon, ClockIcon, MapPinIcon } from '@heroicons/react/24/outline'; // Importing cleaner Heroicons
import EventCard from './EventCard';

const containerVariants = {
    hidden: { opacity: 0 },
    visible: {
        opacity: 1,
        transition: {
            staggerChildren: 0.1,
            delayChildren: 0.2,
        },
    },
};

// --- Main Component: EventsSection (Corporate Redesign with Green) ---
const EventsSection = ({ events }) => {
    const [isModalOpen, setIsModalOpen] = useState(false);
    const [selectedEvent, setSelectedEvent] = useState(null);

    const handleBookClick = (event) => {
        setSelectedEvent(event);
        setIsModalOpen(true);
    };

    const handleCloseModal = () => {
        setIsModalOpen(false);
        setSelectedEvent(null);
    };

    const handleBookingSubmit = (bookingData) => {
        console.log('Booking submitted:', bookingData);
        // Here you would typically handle the form submission, e.g., send to a backend API
        handleCloseModal();
    };

    console.log(events)
    return (
        <section className="bg-white py-16 md:py-24" id="events">
            <div className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                {/* Section Header */}
                <motion.div
                    className="text-center mb-16"
                    initial={{ opacity: 0, y: -20 }}
                    whileInView={{ opacity: 1, y: 0 }}
                    transition={{ duration: 0.6 }}
                    viewport={{ once: true }}
                >
                    <p className="text-sm font-semibold text-emerald-600 uppercase tracking-widest mb-2">
                        PROFESSIONAL DEVELOPMENT
                    </p>
                    <h2 className="text-4xl md:text-5xl font-extrabold text-slate-900">
                        Upcoming Learning & Networking Events
                    </h2>
                    <p className="mt-4 max-w-3xl mx-auto text-lg text-slate-600">
                        Elevate your knowledge and connect with peers through our expert-led workshops and seminars.
                    </p>
                </motion.div>

                {/* Events Grid */}
                <motion.div
                    className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-10"
                    variants={containerVariants}
                    initial="hidden"
                    whileInView="visible"
                    viewport={{ once: true, amount: 0.1 }}
                >
                    {events && events.length > 0 ? (
                        events.map((event) => (
                            <EventCard key={event.id} event={event} onBookClick={handleBookClick} />
                        ))
                    ) : (
                        <div className="col-span-full text-center py-12 border-2 border-dashed border-gray-300 rounded-lg">
                            <p className="text-lg text-slate-500 font-medium">
                                Currently, no upcoming events are scheduled. Please check back soon for updates.
                            </p>
                        </div>
                    )}
                </motion.div>
            </div>

            <EventBookingModal
                event={selectedEvent}
                onClose={handleCloseModal}
                onSubmit={handleBookingSubmit}
            />
        </section>
    );
};

export default EventsSection;