import React, { useEffect } from 'react';
import { usePage } from '@inertiajs/react';
import Swal from 'sweetalert2';

export default function FlashMessage() {
    const { flash } = usePage().props;

    useEffect(() => {
        if (flash && flash.success) {
            Swal.fire({
                icon: 'success',
                title: 'Success!',
                text: flash.success,
                showConfirmButton: false,
                timer: 3000
            });
        }

        if (flash && flash.error) {
            Swal.fire({
                icon: 'error',
                title: 'Error!',
                text: flash.error,
                showConfirmButton: false,
                timer: 3000
            });
        }

        if (flash && flash.message) {
            Swal.fire({
                icon: 'info',
                title: 'Info',
                text: flash.message,
                showConfirmButton: false,
                timer: 3000
            });
        }
    }, [flash]);

    return null; // This component doesn't render anything directly
}
