import React from 'react';

const Preloader = () => {
    return (
        // Full-screen overlay with pure black background for maximum contrast
        <div className="fixed inset-0 flex items-center justify-center bg-black z-50">
            
            {/* Main content container */}
            <div className="flex flex-col items-center">
                
                {/* Enhanced Visual: Animated Green Logo with Pulse Ring */}
                <div className="relative h-32 w-32 mb-10">
                    {/* Outer pulsing ring */}
                    <div className="absolute inset-0 rounded-full border-2 border-green-500 animate-ping opacity-20"></div>
                    
                    {/* Middle expanding ring */}
                    <div className="absolute inset-2 rounded-full border-2 border-green-400 animate-pulse opacity-40"></div>
                    
                    {/* The Logo Container with morphing gradient */}
                    <div className="absolute inset-4 rounded-full bg-gradient-to-br from-green-400 to-green-600 shadow-lg shadow-green-500/50 flex items-center justify-center animate-morph">
                        {/* Logo/Brand */}
                        <div className="text-white text-2xl font-bold tracking-wider">
                            PB
                        </div>
                    </div>
                    
                    {/* Small rotating dots for additional visual interest */}
                    <div className="absolute inset-0 animate-spin-slow">
                        <div className="absolute top-0 left-1/2 transform -translate-x-1/2 w-2 h-2 bg-green-400 rounded-full"></div>
                        <div className="absolute bottom-0 left-1/2 transform -translate-x-1/2 w-2 h-2 bg-green-400 rounded-full"></div>
                        <div className="absolute left-0 top-1/2 transform -translate-y-1/2 w-2 h-2 bg-green-400 rounded-full"></div>
                        <div className="absolute right-0 top-1/2 transform -translate-y-1/2 w-2 h-2 bg-green-400 rounded-full"></div>
                    </div>
                </div>
                
                {/* Enhanced Loading Text with Typewriter Effect */}
                <div className="text-xl font-light tracking-wider text-white mb-6">
                    <span className="inline-block">
                        Promise Balm is loading
                        <span className="inline-block w-1 h-5 bg-green-400 ml-1 animate-blink"></span>
                    </span>
                </div>
                
                {/* Progress Indicator */}
                <div className="w-64 h-1 bg-gray-800 rounded-full overflow-hidden">
                    <div className="h-full bg-gradient-to-r from-green-400 to-green-600 rounded-full animate-progress"></div>
                </div>
                
                {/* Loading Dots */}
                <div className="flex space-x-2 mt-6">
                    <div className="w-2 h-2 bg-green-400 rounded-full animate-bounce" style={{ animationDelay: '0ms' }}></div>
                    <div className="w-2 h-2 bg-green-400 rounded-full animate-bounce" style={{ animationDelay: '150ms' }}></div>
                    <div className="w-2 h-2 bg-green-400 rounded-full animate-bounce" style={{ animationDelay: '300ms' }}></div>
                </div>
            </div>
            
            {/* Add custom styles to the document */}
            <style jsx>{`
                @keyframes morph {
                    0%, 100% {
                        border-radius: 60% 40% 30% 70% / 60% 30% 70% 40%;
                        transform: rotate(0deg);
                    }
                    50% {
                        border-radius: 30% 60% 70% 40% / 50% 60% 30% 60%;
                        transform: rotate(180deg);
                    }
                }
                
                @keyframes spin-slow {
                    from {
                        transform: rotate(0deg);
                    }
                    to {
                        transform: rotate(360deg);
                    }
                }
                
                @keyframes blink {
                    0%, 100% {
                        opacity: 1;
                    }
                    50% {
                        opacity: 0;
                    }
                }
                
                @keyframes progress {
                    0% {
                        width: 0%;
                    }
                    50% {
                        width: 70%;
                    }
                    100% {
                        width: 100%;
                    }
                }
                
                .animate-morph {
                    animation: morph 8s ease-in-out infinite;
                }
                
                .animate-spin-slow {
                    animation: spin-slow 10s linear infinite;
                }
                
                .animate-blink {
                    animation: blink 1s infinite;
                }
                
                .animate-progress {
                    animation: progress 2s ease-in-out infinite;
                }
            `}</style>
        </div>
    );
};

export default Preloader;