import Swal from 'sweetalert2';

// --- Reusable Toast Configuration ---
// This mixin sets the default behavior for all our toasts.
const Toast = Swal.mixin({
    toast: true,
    position: 'top-end', // Appears at the top-right corner
    showConfirmButton: false, // No "OK" button needed for a toast
    timer: 3000, // Disappears after 3 seconds
    timerProgressBar: true,
    didOpen: (toast) => {
        // Allows the user to hover over the toast to pause the timer
        toast.addEventListener('mouseenter', Swal.stopTimer);
        toast.addEventListener('mouseleave', Swal.resumeTimer);
    }
});

// --- Success Toast ---
// Uses a professional green background with the default success icon.
export const showSuccessToast = (message = 'Operation successful!') => {
    Toast.fire({
        icon: 'success',
        title: 'Success!',
        text: message,
        background: '#059669', // emerald-600
        color: '#ffffff',
    });
};
// --- Error Toast ---
// Uses a dark, neutral background to feel serious but not alarming.
export const showErrorToast = (message = 'Something went wrong.') => {
    Toast.fire({
        icon: 'error',
        title: 'Error!',
        text: message,
        background: '#1f2937', // gray-800
        color: '#ffffff',
    });
};

// --- Info Toast (Optional, but good to have) ---
// Useful for neutral updates or warnings.
export const showInfoToast = (message = 'Here is an update.') => {
    Toast.fire({
        icon: 'info',
        title: 'Info',
        text: message,
        background: '#374151', // gray-700
        color: '#ffffff',
    });
};