import AdminLayout from '@/Layouts/AdminLayout';
import { Head, Link, useForm } from '@inertiajs/react';

export default function Show({ auth, booking, doctors }) {
    const { data, setData, post, processing, errors } = useForm({
        doctor_id: booking.doctor_id || '',
    });

    const isServiceBooking = booking.bookable_type === 'App\\Models\\Service';

    console.log(booking)

    const submit = (e) => {
        e.preventDefault();
        post(route('admin.bookings.assign-doctor', booking.id));
    };

    const getStatusColor = (status) => {
        switch (status) {
            case 'confirmed':
                return 'bg-green-100 text-green-800 border-green-200';
            case 'paid':
                return 'bg-emerald-100 text-emerald-800 border-emerald-200';
            case 'pending':
                return 'bg-yellow-100 text-yellow-800 border-yellow-200';
            case 'completed':
                return 'bg-teal-100 text-teal-800 border-teal-200';
            case 'cancelled':
                return 'bg-red-100 text-red-800 border-red-200';
            default:
                return 'bg-gray-100 text-gray-800 border-gray-200';
        }
    };

    const getStatusIcon = (status) => {
        switch (status) {
            case 'confirmed':
                return (
                    <svg className="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                        <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clipRule="evenodd" />
                    </svg>
                );
            case 'paid':
                return (
                    <svg className="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                        <path d="M8.433 7.418c.155-.103.346-.196.567-.267v1.698a2.305 2.305 0 01-.567-.267C8.07 8.34 8 8.114 8 8c0-.114.07-.34.433-.582zM11 12.849v-1.698c.22.071.412.164.567.267.364.243.433.468.433.582 0 .114-.07.34-.433.582a2.305 2.305 0 01-.567.267z" />
                        <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-13a1 1 0 10-2 0v.092a4.535 4.535 0 00-1.676.662C6.602 6.234 6 7.009 6 8c0 .99.602 1.765 1.324 2.246.48.32 1.054.545 1.676.662v1.941c-.391-.127-.68-.317-.843-.504a1 1 0 10-1.51 1.31c.562.649 1.413 1.076 2.353 1.253V15a1 1 0 102 0v-.092a4.535 4.535 0 001.676-.662C13.398 13.766 14 12.991 14 12c0-.99-.602-1.765-1.324-2.246A4.535 4.535 0 0011 9.092V7.151c.391.127.68.317.843.504a1 1 0 101.511-1.31c-.563-.649-1.413-1.076-2.354-1.253V5z" clipRule="evenodd" />
                    </svg>
                );
            case 'pending':
                return (
                    <svg className="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                        <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm1-12a1 1 0 10-2 0v4a1 1 0 00.293.707l2.828 2.829a1 1 0 101.415-1.415L11 9.586V6z" clipRule="evenodd" />
                    </svg>
                );
            case 'completed':
                return (
                    <svg className="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                        <path fillRule="evenodd" d="M6.267 3.455a3.066 3.066 0 001.745-.723 3.066 3.066 0 013.976 0 3.066 3.066 0 001.745.723 3.066 3.066 0 012.812 2.812c.051.643.304 1.254.723 1.745a3.066 3.066 0 010 3.976 3.066 3.066 0 00-.723 1.745 3.066 3.066 0 01-2.812 2.812 3.066 3.066 0 00-1.745.723 3.066 3.066 0 01-3.976 0 3.066 3.066 0 00-1.745-.723 3.066 3.066 0 01-2.812-2.812 3.066 3.066 0 00-.723-1.745 3.066 3.066 0 010-3.976 3.066 3.066 0 00.723-1.745 3.066 3.066 0 012.812-2.812zm7.44 5.252a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clipRule="evenodd" />
                    </svg>
                );
            case 'cancelled':
                return (
                    <svg className="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                        <path fillRule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clipRule="evenodd" />
                    </svg>
                );
            default:
                return null;
        }
    };

    const formatCurrency = (amount) => {
        return new Intl.NumberFormat('en-GH', {
            style: 'currency',
            currency: 'GHS',
            minimumFractionDigits: 2,
            maximumFractionDigits: 2,
        }).format(amount);
    };

    return (
        <AdminLayout user={auth.user}>
            <Head title={`Booking #${booking.reference_id}`} />

            <div className="py-12 px-4 sm:px-6 lg:px-8 bg-gradient-to-br from-green-50 to-emerald-100 min-h-screen">
                <div className="max-w-7xl mx-auto">
                    <div className="bg-white overflow-hidden shadow-xl rounded-2xl">
                        <div className="bg-gradient-to-r from-green-600 to-emerald-600 p-6">
                            <div className="flex justify-between items-center">
                                <div>
                                    <h1 className="text-2xl font-bold text-white">Booking Details</h1>
                                    <p className="text-green-100 mt-1">Reference: #{booking.reference_id}</p>
                                </div>
                                <Link 
                                    href={route('admin.bookings.index')} 
                                    className="inline-flex items-center px-4 py-2 bg-white bg-opacity-20 backdrop-blur-sm rounded-lg text-white hover:bg-opacity-30 transition-all duration-200"
                                >
                                    <svg className="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M10 19l-7-7m0 0l7-7m-7 7h18" />
                                    </svg>
                                    Back to Bookings
                                </Link>
                            </div>
                        </div>
                        
                        <div className="p-6">
                            <div className="grid grid-cols-1 lg:grid-cols-2 gap-6">
                                <div className="bg-gray-50 rounded-xl p-6 shadow-sm">
                                    <div className="flex items-center mb-4">
                                        <div className="w-10 h-10 bg-green-100 rounded-full flex items-center justify-center mr-3">
                                            <svg className="w-6 h-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z" />
                                            </svg>
                                        </div>
                                        <h3 className="text-lg font-semibold text-gray-900">Booking Information</h3>
                                    </div>
                                    
                                    <div className="space-y-4">
                                        <div className="flex justify-between">
                                            <span className="text-gray-500">Reference ID:</span>
                                            <span className="font-medium text-gray-900">#{booking.reference_id}</span>
                                        </div>
                                        
                                        <div className="flex justify-between">
                                            <span className="text-gray-500">User:</span>
                                            <div className="flex items-center">
                                                <img className="h-8 w-8 rounded-full mr-2" src={`https://ui-avatars.com/api/?name=${booking.user.name}&background=10b981&color=fff`} alt="" />
                                                <span className="font-medium text-gray-900">{booking.user.name}</span>
                                            </div>
                                        </div>
                                        
                                        <div className="flex justify-between">
                                            <span className="text-gray-500">Email:</span>
                                            <span className="font-medium text-gray-900">{booking.user.email}</span>
                                        </div>
                                        
                                        <div className="flex justify-between">
                                            <span className="text-gray-500">Date:</span>
                                            <span className="font-medium text-gray-900">
                                                {new Date(booking.booking_date).toLocaleDateString('en-US', { 
                                                    year: 'numeric', 
                                                    month: 'long', 
                                                    day: 'numeric' 
                                                })}
                                            </span>
                                        </div>
                                        
                                        <div className="flex justify-between">
                                            <span className="text-gray-500">Price:</span>
                                            <div className="flex items-center">
                                                <span className="text-green-600 font-bold mr-1">GH₵</span>
                                                <span className="font-medium text-gray-900">{booking.price}</span>
                                            </div>
                                        </div>
                                        
                                        <div className="flex justify-between">
                                            <span className="text-gray-500">Status:</span>
                                            <span className={`inline-flex items-center px-3 py-1 rounded-full text-xs font-medium border ${getStatusColor(booking.status)}`}>
                                                {getStatusIcon(booking.status)}
                                                {booking.status.charAt(0).toUpperCase() + booking.status.slice(1)}
                                            </span>
                                        </div>
                                        <div className="flex justify-between">
                                            <span className="text-gray-500">Assigned Doctor:</span>
                                            <div className="flex items-center">
                                                {booking.doctor ? (
                                                    <>
                                                        <img className="h-8 w-8 rounded-full mr-2" src={`https://ui-avatars.com/api/?name=${booking.doctor.name}&background=10b981&color=fff`} alt="" />
                                                        <span className="font-medium text-gray-900">{booking.doctor.name}</span>
                                                    </>
                                                ) : (
                                                    <span className="font-medium text-gray-900">Not Assigned</span>
                                                )}
                                            </div>
                                        </div>
                                        
                                        <div className="flex justify-between">
                                            <span className="text-gray-500">Assigned Doctor:</span>
                                            <div className="flex items-center">
                                                {booking.doctor ? (
                                                    <>
                                                        <img className="h-8 w-8 rounded-full mr-2" src={`https://ui-avatars.com/api/?name=${booking.doctor.name}&background=10b981&color=fff`} alt="" />
                                                        <span className="font-medium text-gray-900">{booking.doctor.name}</span>
                                                    </>
                                                ) : (
                                                    <span className="font-medium text-gray-900">Not Assigned</span>
                                                )}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <div className="bg-gray-50 rounded-xl p-6 shadow-sm">
                                    <div className="flex items-center mb-4">
                                        <div className="w-10 h-10 bg-emerald-100 rounded-full flex items-center justify-center mr-3">
                                            <svg className="w-6 h-6 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                                            </svg>
                                        </div>
                                        <h3 className="text-lg font-semibold text-gray-900">Item Details</h3>
                                    </div>
                                    
                                    <div className="space-y-4">
                                        <div className="flex justify-between">
                                            <span className="text-gray-500">Type:</span>
                                            <span className="px-2 py-1 text-xs font-medium rounded-full bg-emerald-100 text-emerald-800">
                                                {booking.bookable_type.split('\\').pop()}
                                            </span>
                                        </div>
                                        
                                        <div className="flex justify-between">
                                            <span className="text-gray-500">Name:</span>
                                            <span className="font-medium text-gray-900">
                                                {booking.bookable.name || booking.bookable.title}
                                            </span>
                                        </div>
                                        
                                        {booking.bookable.description && (
                                            <div>
                                                <span className="text-gray-500">Description:</span>
                                                <p className="mt-1 text-sm text-gray-700">{booking.bookable.description}</p>
                                            </div>
                                        )}
                                        
                                        {booking.bookable.duration && (
                                            <div className="flex justify-between">
                                                <span className="text-gray-500">Duration:</span>
                                                <span className="font-medium text-gray-900">{booking.bookable.duration}</span>
                                            </div>
                                        )}
                                    </div>
                                </div>
                            </div>

                            {isServiceBooking && booking.status === "confirmed" && (
                                <div className="mt-8 bg-gray-50 rounded-xl p-6 shadow-sm">
                                    <div className="flex items-center mb-6">
                                        <div className="w-10 h-10 bg-teal-100 rounded-full flex items-center justify-center mr-3">
                                            <svg className="w-6 h-6 text-teal-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                                            </svg>
                                        </div>
                                        <h3 className="text-lg font-semibold text-gray-900">Assign Doctor</h3>
                                    </div>
                                    
                                    <form onSubmit={submit}>
                                        <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
                                            <div>
                                                <label htmlFor="doctor_id" className="block text-sm font-medium text-gray-700 mb-2">
                                                    Select Doctor
                                                </label>
                                                <div className="relative">
                                                    <select
                                                        id="doctor_id"
                                                        name="doctor_id"
                                                        value={data.doctor_id}
                                                        onChange={(e) => setData('doctor_id', e.target.value)}
                                                        className="mt-1 block w-full pl-3 pr-10 py-3 text-base border-gray-300 focus:outline-none focus:ring-green-500 focus:border-green-500 sm:text-sm rounded-md appearance-none bg-white"
                                                    >
                                                        <option value="">Select a doctor</option>
                                                        {doctors.map((doctor) => (
                                                            <option key={doctor.id} value={doctor.id}>
                                                                {doctor.name}
                                                            </option>
                                                        ))}
                                                    </select>
                                                    <div className="absolute inset-y-0 right-0 flex items-center pr-3 pointer-events-none">
                                                        <svg className="h-5 w-5 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M19 9l-7 7-7-7" />
                                                        </svg>
                                                    </div>
                                                </div>
                                                {errors.doctor_id && (
                                                    <p className="mt-2 text-sm text-red-600 flex items-center">
                                                        <svg className="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                                            <path fillRule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clipRule="evenodd" />
                                                        </svg>
                                                        {errors.doctor_id}
                                                    </p>
                                                )}
                                            </div>
                                            
                                            <div className="flex items-end">
                                                <button
                                                    type="submit"
                                                    className="inline-flex items-center px-6 py-3 bg-green-600 border border-transparent rounded-md font-semibold text-sm text-white hover:bg-green-700 active:bg-green-800 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-green-500 disabled:opacity-25 transition ease-in-out duration-150"
                                                    disabled={processing}
                                                >
                                                    {processing ? (
                                                        <>
                                                            <svg className="animate-spin -ml-1 mr-2 h-4 w-4 text-white" fill="none" viewBox="0 0 24 24">
                                                                <circle className="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" strokeWidth="4"></circle>
                                                                <path className="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                                                            </svg>
                                                            Processing...
                                                        </>
                                                    ) : (
                                                        <>
                                                            <svg className="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path strokeLinecap="round" strokeLinejoin="round" strokeWidth="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" />
                                                            </svg>
                                                            Assign Doctor
                                                        </>
                                                    )}
                                                </button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            )}
                        </div>
                    </div>
                </div>
            </div>
        </AdminLayout>
    );
}