import React from 'react';
import AdminLayout from '@/Layouts/AdminLayout';
import { Head } from '@inertiajs/react';
import { ClipboardDocumentCheckIcon } from '@heroicons/react/24/outline';

const BookingCard = ({ bookingDetail }) => {
    const { booking, service } = bookingDetail;
    const patient = booking.user;

    return (
        <li className="bg-white shadow-sm rounded-lg overflow-hidden hover:shadow-md transition-shadow duration-300">
            <div className="p-6">
                <div className="flex items-center justify-between">
                    <div className="flex-1 min-w-0">
                        <p className="text-lg font-semibold text-gray-900 truncate">{service.name}</p>
                        <div className="mt-2 flex items-center text-sm text-gray-500">
                            <span className="truncate">Patient: {patient.name}</span>
                        </div>
                        <p className="mt-1 text-sm text-gray-500">Booking Date: {new Date(booking.booking_date).toLocaleDateString()}</p>
                    </div>
                    <div className="flex items-center space-x-6 ml-4">
                        <div className="text-right">
                            <span className={`inline-flex items-center px-3 py-1 rounded-full text-sm font-medium ${
                                booking.status === 'confirmed' ? 'bg-green-100 text-green-800' :
                                booking.status === 'pending' ? 'bg-yellow-100 text-yellow-800' :
                                'bg-red-100 text-red-800'
                            }`}>
                                {booking.status}
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </li>
    );
};

export default function Dashboard({ auth, serviceBookings }) {
    return (
        <AdminLayout
            user={auth.user}
            header={
                <div>
                    <h2 className="font-semibold text-2xl text-gray-800 leading-tight">Doctor's Dashboard</h2>
                    <p className="mt-1 text-sm text-gray-600">Your assigned service bookings.</p>
                </div>
            }
        >
            <Head title="Doctor's Dashboard" />

            <div className="py-6">
                <div className="mx-auto sm:px-6 lg:px-8">
                    <div className="flex justify-between items-center mb-6">
                        <h3 className="text-2xl font-bold text-gray-900">Assigned Service Bookings</h3>
                    </div>

                    <div className="bg-white shadow-lg rounded-lg overflow-hidden">
                        {serviceBookings.data.length > 0 ? (
                            <ul className="divide-y divide-gray-200">
                                {serviceBookings.data.map((bookingDetail) => (
                                    <BookingCard key={bookingDetail.id} bookingDetail={bookingDetail} />
                                ))}
                            </ul>
                        ) : (
                            <div className="text-center py-12">
                                <ClipboardDocumentCheckIcon className="mx-auto h-12 w-12 text-gray-400" />
                                <h3 className="mt-2 text-sm font-medium text-gray-900">No assigned bookings</h3>
                                <p className="mt-1 text-sm text-gray-500">You have no service bookings assigned to you yet.</p>
                            </div>
                        )}
                    </div>

                    {serviceBookings.links && serviceBookings.links.length > 3 && (
                        <div className="mt-6 flex justify-center">
                            {serviceBookings.links.map((link, key) => (
                                <Link
                                    key={key}
                                    href={link.url || '#'}
                                    className={`mr-1 mb-1 px-4 py-3 text-sm leading-4 border rounded-md transition-colors duration-150 ${
                                        link.active
                                            ? 'bg-emerald-600 text-white border-emerald-600'
                                            : 'bg-white text-gray-700 border-gray-300 hover:bg-gray-50'
                                    } ${!link.url ? 'opacity-50 cursor-not-allowed' : ''}`}
                                    dangerouslySetInnerHTML={{ __html: link.label }}
                                />
                            ))}
                        </div>
                    )}
                </div>
            </div>
        </AdminLayout>
    );
}
