import React from 'react';
import AdminLayout from '@/Layouts/AdminLayout';
import { Head, Link } from '@inertiajs/react';

export default function GalleryIndex({ galleries }) {
    return (
        <AdminLayout>
            <Head title="Gallery Management" />

            <div className="py-8 px-4 sm:px-6 lg:px-8">
                <div className="max-w-7xl mx-auto">
                    {/* Header Section */}
                    <div className="mb-8 text-center">
                        <h1 className="text-3xl font-bold text-gray-900 mb-2">Gallery Management</h1>
                        <p className="text-gray-600 max-w-2xl mx-auto">
                            Manage your organization's visual assets. Add, edit, or remove gallery items to maintain an up-to-date portfolio.
                        </p>
                    </div>

                    {/* Action Bar */}
                    <div className="flex justify-between items-center mb-6 p-4 bg-gray-50 rounded-lg">
                        <div>
                            <h2 className="text-lg font-medium text-gray-900">Gallery Items</h2>
                            <p className="text-sm text-gray-500">
                                {galleries.length} {galleries.length === 1 ? 'item' : 'items'} in your gallery
                            </p>
                        </div>
                        <Link
                            href={route('admin.gallery.create')}
                            className="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500 transition-colors duration-200"
                        >
                            <svg className="-ml-1 mr-2 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                <path fillRule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" clipRule="evenodd" />
                            </svg>
                            Add New Item
                        </Link>
                    </div>

                    {/* Gallery Grid */}
                    <div className="bg-white shadow overflow-hidden sm:rounded-md">
                        {galleries.length > 0 ? (
                            <ul className="divide-y divide-gray-200">
                                {galleries.map((item) => (
                                    <li key={item.id} className="hover:bg-gray-50 transition-colors duration-150">
                                        <div className="px-4 py-4 sm:px-6">
                                            <div className="flex items-center">
                                                <div className="min-w-0 flex-1 flex items-center">
                                                    <div className="flex-shrink-0">
                                                        <img className="h-16 w-16 rounded-lg object-cover" src={item.url} alt={item.title} />
                                                    </div>
                                                    <div className="min-w-0 flex-1 px-4">
                                                        <div>
                                                            <h3 className="text-lg font-medium text-blue-600 truncate">{item.title}</h3>
                                                            <p className="mt-1 text-sm text-gray-500">{item.description}</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div className="ml-4 flex-shrink-0 flex space-x-3">
                                                    <Link
                                                        href={route('admin.gallery.edit', item.id)}
                                                        className="inline-flex items-center px-3 py-1 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                                                    >
                                                        Edit
                                                    </Link>
                                                    <Link
                                                        href={route('admin.gallery.destroy', item.id)}
                                                        method="delete"
                                                        as="button"
                                                        className="inline-flex items-center px-3 py-1 border border-transparent text-sm font-medium rounded-md text-white bg-red-600 hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-red-500"
                                                    >
                                                        Delete
                                                    </Link>
                                                </div>
                                            </div>
                                        </div>
                                    </li>
                                ))}
                            </ul>
                        ) : (
                            <div className="text-center py-12">
                                <svg className="mx-auto h-12 w-12 text-gray-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                                    <path strokeLinecap="round" strokeLinejoin="round" strokeWidth={2} d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z" />
                                </svg>
                                <h3 className="mt-2 text-sm font-medium text-gray-900">No gallery items</h3>
                                <p className="mt-1 text-sm text-gray-500">Get started by creating a new gallery item.</p>
                                <div className="mt-6">
                                    <Link
                                        href={route('admin.gallery.create')}
                                        className="inline-flex items-center px-4 py-2 border border-transparent shadow-sm text-sm font-medium rounded-md text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500"
                                    >
                                        <svg className="-ml-1 mr-2 h-5 w-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                            <path fillRule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" clipRule="evenodd" />
                                        </svg>
                                        Add First Item
                                    </Link>
                                </div>
                            </div>
                        )}
                    </div>
                </div>
            </div>
        </AdminLayout>
    );
}