import React from 'react';
import AdminLayout from '@/Layouts/AdminLayout';
import { Head } from '@inertiajs/react';

export default function Show({ auth, schoolService }) {
    return (
        <AdminLayout
            user={auth.user}
            header={<h2 className="font-semibold text-xl text-gray-800 leading-tight">School Service Details</h2>}
        >
            <Head title="School Service Details" />

            <div className="py-12">
                <div className="max-w-7xl mx-auto sm:px-6 lg:px-8">
                    <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                        <div className="p-6 text-gray-900">
                            <h3 className="text-lg font-medium text-gray-900 mb-4">{schoolService.name}</h3>

                            <div className="grid grid-cols-1 gap-4">
                                <div>
                                    <p className="text-sm text-gray-600"><strong>Description:</strong> {schoolService.description}</p>
                                    <p className="text-sm text-gray-600"><strong>Price:</strong> ${schoolService.price}</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </AdminLayout>
    );
}
