<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Booking Payment Confirmation</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background-color: #f5f7fa;
        }
        
        .email-container {
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
        }
        
        .header {
            background: linear-gradient(135deg, #10b981, #059669);
            padding: 30px 20px;
            text-align: center;
        }
        
        .header h1 {
            color: white;
            font-size: 28px;
            font-weight: 600;
            margin-bottom: 5px;
        }
        
        .header p {
            color: rgba(255, 255, 255, 0.9);
            font-size: 16px;
        }
        
        .content {
            padding: 30px 20px;
        }
        
        .greeting {
            font-size: 18px;
            margin-bottom: 20px;
            color: #374151;
        }
        
        .confirmation-message {
            background-color: #ecfdf5;
            border-left: 4px solid #10b981;
            padding: 15px;
            margin-bottom: 25px;
            border-radius: 0 4px 4px 0;
        }
        
        .confirmation-message p {
            color: #065f46;
            font-size: 16px;
        }
        
        .booking-details {
            background-color: #f9fafb;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 25px;
        }
        
        .booking-details h3 {
            color: #111827;
            font-size: 18px;
            margin-bottom: 15px;
            display: flex;
            align-items: center;
        }
        
        .booking-details h3 svg {
            margin-right: 8px;
            color: #10b981;
        }
        
        .detail-item {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #e5e7eb;
        }
        
        .detail-item:last-child {
            border-bottom: none;
        }
        
        .detail-label {
            font-weight: 600;
            color: #4b5563;
        }
        
        .detail-value {
            color: #111827;
            font-weight: 500;
        }
        
        .status-badge {
            display: inline-flex;
            align-items: center;
            padding: 4px 12px;
            border-radius: 9999px;
            font-size: 14px;
            font-weight: 600;
        }
        
        .status-confirmed {
            background-color: #d1fae5;
            color: #065f46;
        }
        
        .status-paid {
            background-color: #d1fae5;
            color: #065f46;
        }
        
        .status-pending {
            background-color: #fed7aa;
            color: #92400e;
        }
        
        .status-completed {
            background-color: #dbeafe;
            color: #1e40af;
        }
        
        .status-cancelled {
            background-color: #fee2e2;
            color: #991b1b;
        }
        
        .cta-container {
            text-align: center;
            margin: 30px 0;
        }
        
        .cta-button {
            display: inline-block;
            background: linear-gradient(135deg, #10b981, #059669);
            color: #ffffff !important; /* Explicitly set to white with !important */
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            font-size: 16px;
            transition: all 0.3s ease;
            box-shadow: 0 4px 6px rgba(16, 185, 129, 0.3);
            text-shadow: 0 1px 1px rgba(0, 0, 0, 0.1); /* Added text shadow for better readability */
        }
        
        .cta-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 8px rgba(16, 185, 129, 0.4);
        }
        
        .footer {
            background-color: #f9fafb;
            padding: 20px;
            text-align: center;
            border-top: 1px solid #e5e7eb;
        }
        
        .footer p {
            color: #6b7280;
            font-size: 14px;
        }
        
        .footer .company-name {
            font-weight: 600;
            color: #10b981;
        }
        
        @media only screen and (max-width: 600px) {
            .email-container {
                width: 100%;
                border-radius: 0;
            }
            
            .header h1 {
                font-size: 24px;
            }
            
            .content {
                padding: 20px 15px;
            }
            
            .detail-item {
                flex-direction: column;
                gap: 5px;
            }
        }
    </style>
</head>
<body>
    <div class="email-container">
        <div class="header">
            <h1>Payment Confirmation</h1>
            <p>Your booking has been successfully paid and confirmed!</p>
        </div>
        
        <div class="content">
            <p class="greeting">Dear {{ $booking->user->name ?? 'User' }},</p>
            
            <div class="confirmation-message">
                <p>Thank you for your payment! Your booking has been successfully confirmed. We are excited to serve you and look forward to providing you with an excellent experience.</p>
            </div>
            
            <div class="booking-details">
                <h3>
                    <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                        <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                        <polyline points="14 2 14 8 20 8"></polyline>
                        <line x1="16" y1="13" x2="8" y2="13"></line>
                        <line x1="16" y1="17" x2="8" y2="17"></line>
                        <polyline points="10 9 9 9 8 9"></polyline>
                    </svg>
                    Booking Details
                </h3>
                
                <div class="detail-item">
                    <span class="detail-label">Booking ID:</span>
                    <span class="detail-value">#{{ $booking->id }}</span>
                </div>
                
                <div class="detail-item">
                    <span class="detail-label">Reference:</span>
                    <span class="detail-value">{{ $booking->reference_id }}</span>
                </div>
                
                <div class="detail-item">
                    <span class="detail-label">Status:</span>
                    <span class="detail-value">
                        <span class="status-badge status-{{ $booking->status }}">
                            {{ ucfirst($booking->status) }}
                        </span>
                    </span>
                </div>
                
                <div class="detail-item">
                    <span class="detail-label">Price:</span>
                    <span class="detail-value">GH₵{{ number_format($booking->price, 2) }}</span>
                </div>
                
                <div class="detail-item">
                    <span class="detail-label">Booking Date:</span>
                    <span class="detail-value">{{ \Carbon\Carbon::parse($booking->booking_date)->format('l, F j, Y') }}</span>
                </div>
                
                @if(isset($booking->bookable))
                <div class="detail-item">
                    <span class="detail-label">Service:</span>
                    <span class="detail-value">{{ $booking->bookable->name ?? $booking->bookable->title ?? 'N/A' }}</span>
                </div>
                @endif
            </div>
            
            <div class="cta-container">
                <a href="{{ url('/user/bookings/' . $booking->id) }}" class="cta-button" style="color: #ffffff !important; text-decoration: none;">View Full Booking Details</a>
            </div>
            
            <p>If you have any questions about your booking, please do not hesitate to contact our support team.</p>
        </div>
        
        <div class="footer">
            <p>Thank you for choosing <span class="company-name">PromiseBalm</span>!</p>
            <p>© {{ date('Y') }} PromiseBalm. All rights reserved.</p>
        </div>
    </div>
</body>
</html>