<?php
use App\Http\Controllers\PaymentResultController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\ServiceController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\CoreValuesController;
use App\Http\Controllers\QuotePageController;
use App\Http\Controllers\AboutController;
use App\Http\Controllers\Admin\EventController;
use App\Http\Controllers\ServicePageController;
use App\Http\Controllers\PortfolioPageController;
use App\Http\Controllers\TeamPageController;
use App\Http\Controllers\ContactPageController;
use App\Http\Controllers\GalleryController;
use App\Http\Controllers\Admin\GalleryController as AdminGalleryController;
use App\Http\Controllers\Admin\ProductController as AdminProductController;
use App\Http\Controllers\Admin\DoctorController;
use App\Http\Controllers\Admin\ProductCategoryController;

use App\Http\Controllers\Admin\NotificationController;
use App\Http\Controllers\Admin\AdminBookingController;
use App\Http\Controllers\Admin\ConversationController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\SchoolController;
use App\Http\Controllers\Admin\AdminPaymentSettingsController;
use App\Http\Controllers\Admin\PostController;
use App\Http\Controllers\EventPageController;
use App\Http\Controllers\SchoolPageController;
use App\Http\Controllers\ShopPageController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\BookingController;

use App\Http\Controllers\CartController;
use App\Http\Controllers\CheckoutController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\User\UserDashboardController;
use App\Http\Controllers\User\UserBookingController;
use App\Http\Controllers\User\UserMessageController;
use App\Http\Controllers\User\UserTicketController;
use App\Http\Controllers\User\UserOrderController;


use Illuminate\Support\Facades\Route;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PaypalController;
use App\Http\Controllers\PaystackController;
use App\Http\Controllers\User\UserNotificationController;
use App\Http\Controllers\User\UserSchoolServiceBookingController;

Route::get('/quote', [QuotePageController::class, 'create'])->name('quote.create');
Route::post('/quote', [QuotePageController::class, 'store'])->name('quote.store');
Route::get('/about', [AboutController::class, 'index'])->name('about.index');
Route::get('/services', [ServicePageController::class, 'index'])->name('services.index');
Route::get('/portfolio', [PortfolioPageController::class, 'index'])->name('portfolio.index');
Route::get('/team', [TeamPageController::class, 'index'])->name('team.index');
Route::get('/gallery', [GalleryController::class, 'index'])->name('gallery.index');
Route::get('/contact', [ContactPageController::class, 'index'])->name('contact.index');
Route::get('/', [HomeController::class, 'index'])->name('home');

Route::post('/cart/add', [CartController::class, 'addToCart'])->name('cart.add');
Route::patch('/cart/update/{rowId}', [CartController::class, 'updateQuantity'])->name('cart.update');
Route::delete('/cart/remove/{rowId}', [CartController::class, 'removeItem'])->name('cart.remove');


Route::get('/cart', [CartController::class, 'viewCart'])->name('cart.view');
Route::post('/checkout', [CheckoutController::class, 'store'])->name('checkout.store');
Route::get('/tickets', [EventPageController::class, 'index'])->name('events');
Route::get('/our-school', [SchoolPageController::class, 'index'])->name('school');
Route::get('/our-services', [ServicePageController::class, 'index'])->name('services');
Route::get('/shop', [ShopPageController::class, 'index'])->name('shop');
Route::get('/blog', [BlogController::class, 'index'])->name('blog.index');
Route::get('/blog/{post}', [BlogController::class, 'show'])->name('blog.show');
Route::get('/contact', [ContactPageController::class, 'index'])->name('contact');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::post('/orders', [OrderController::class, 'store'])->name('orders.store');

    Route::post('/bookings', [BookingController::class, 'store'])->name('bookings.store');
    Route::post('/bookings/{booking}/update-status', [BookingController::class, 'updateStatus'])->name('bookings.update-status');    
    Route::post('/bookings/{booking}/initiate-payment', [BookingController::class, 'initiatePayment'])->name('bookings.initiate-payment');
});

Route::middleware(['auth', 'verified'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::get('/sliders', [SliderController::class, 'index'])->name('sliders.index');
    Route::get('/sliders/create', [SliderController::class, 'create'])->name('sliders.create');
    Route::get('/sliders/{slider}/edit', [SliderController::class, 'edit'])->name('sliders.edit');
    // Services
    Route::resource('services', ServiceController::class);
    Route::resource('products', AdminProductController::class);

    Route::resource('product-categories', ProductCategoryController::class);
    Route::resource('doctors', DoctorController::class);
    Route::middleware(['role:doctor'])->group(function () {
        Route::get('/doctor/dashboard', [DoctorController::class, 'dashboard'])->name('doctor.dashboard');
    });
    Route::resource('school-services', SchoolController::class);
    Route::resource('orders', OrderController::class);
    Route::resource('conversations', ConversationController::class);
    Route::resource('posts', PostController::class);
    Route::resource('bookings', AdminBookingController::class);
    Route::post('bookings/{booking}/assign-doctor', [AdminBookingController::class, 'assignDoctor'])->name('bookings.assign-doctor');

    Route::get('/notifications', [NotificationController::class, 'index'])->name('notifications.index');
    Route::post('/notifications/{notification}/mark-as-read', [NotificationController::class, 'markAsRead'])->name('notifications.markAsRead');
    Route::delete('/notifications/{notification}', [NotificationController::class, 'destroy'])->name('notifications.destroy');        
    Route::resource('events', EventController::class);
    // Teams
    Route::get('/teams', [TeamController::class, 'index'])->name('teams.index');
    Route::get('/teams/create', [TeamController::class, 'create'])->name('teams.create');
    Route::get('/teams/{team}/edit', [TeamController::class, 'edit'])->name('teams.edit');
    // Settings
    Route::get('/settings', function(){
        return redirect()->route('admin.settings.edit', ['setting' => 1]);
    })->name('settings.index');
    Route::get('/settings/{setting}/edit', [SettingController::class, 'edit'])->name('settings.edit');
    Route::post('/settings/{setting}', [SettingController::class, 'update'])->name('settings.update');
    // Gallery
    Route::get('/gallery', [AdminGalleryController::class, 'index'])->name('gallery.index');
    Route::get('/gallery/create', [AdminGalleryController::class, 'create'])->name('gallery.create');
    Route::post('/gallery', [AdminGalleryController::class, 'store'])->name('gallery.store');
    Route::get('/gallery/{gallery}/edit', [AdminGalleryController::class, 'edit'])->name('gallery.edit');
    Route::put('/gallery/{gallery}', [AdminGalleryController::class, 'update'])->name('gallery.update');
    Route::delete('/gallery/{gallery}', [AdminGalleryController::class, 'destroy'])->name('gallery.destroy');
    // Core Values
    Route::get('/settings/core-values', [CoreValuesController::class, 'index'])->name('settings.core-values.index');
    Route::post('/settings/core-values', [CoreValuesController::class, 'update'])->name('settings.core-values.update');

    // Admin Payment Settings
    Route::get('/payment-settings', [AdminPaymentSettingsController::class, 'edit'])->name('payment-settings.edit');
    Route::put('/payment-settings', [AdminPaymentSettingsController::class, 'update'])->name('payment-settings.update');
});

// User Routes (role >= 100)
Route::middleware(['auth', 'verified'])->prefix('user')->name('user.')->group(function () {

    Route::get('/dashboard', [UserDashboardController::class, 'index'])->name('dashboard');
    Route::get('/bookings', [UserBookingController::class, 'index'])->name('bookings.index');
    Route::get('/bookings/{booking}', [UserBookingController::class, 'show'])->name('bookings.show');
    Route::post('/bookings/{booking}/confirm', [UserBookingController::class, 'confirm'])->name('bookings.confirm');
    Route::post('/bookings/{booking}/reschedule', [UserBookingController::class, 'reschedule'])->name('bookings.reschedule');
    Route::post('/bookings/{booking}/cancel', [UserBookingController::class, 'cancel'])->name('bookings.cancel');
    Route::get('/notifications', [UserNotificationController::class, 'index'])->name('notifications.index');
    Route::get('/messages', [UserMessageController::class, 'index'])->name('messages.index');
    Route::resource('/tickets', UserTicketController::class);
    Route::resource('/orders', UserOrderController::class);
    Route::get('/school-services', [UserSchoolServiceBookingController::class, 'index'])->name('school-services.index');
    Route::get('/school-services/{booking}', [UserSchoolServiceBookingController::class, 'show'])->name('school-services.show');
    Route::post('/school-services/{booking}/message-instructor', [UserSchoolServiceBookingController::class, 'messageInstructor'])->name('school-services.message-instructor');

});

// Doctor Routes (role == 200)
Route::middleware(['auth', 'verified', 'role:doctor'])->prefix('user')->name('user.')->group(function () {
    Route::get('/doctors/assigned-bookings', [DoctorController::class, 'assignedBookings'])->name('doctors.assigned-bookings');
    Route::post('/doctors/assigned-bookings/{booking}/update-approval-status', [DoctorController::class, 'updateApprovalStatus'])->name('doctors.assigned-bookings.update-approval-status');
});

// PayPal Routes
Route::post('/paypal/payment/initiate', [PaymentController::class, 'initiatePaypalPayment'])->name('paypal.initiate');
Route::get('/paypal/success', [PaymentController::class, 'paypalSuccess'])->name('paypal.success');
Route::get('/paypal/cancel', [PaymentController::class, 'paypalCancel'])->name('paypal.cancel');

// Paystack Routes
Route::post('/paystack/payment/initiate', [PaymentController::class, 'initiatePaystackPayment'])->name('paystack.initiate');
Route::get('/paystack/callback', [PaymentController::class, 'paystackCallback'])->name('paystack.callback');
Route::get('/payment/success', [PaymentResultController::class, 'success'])->name('payment.success');

Route::get('/payment/failure', [PaymentResultController::class, 'failure'])->name('payment.failure');
Route::post('/checkout', [CheckoutController::class, 'store'])->name('checkout.store');
Route::post('/paystack/initiate', [PaystackController::class, 'initiate'])->name('paystack.initiate');
Route::post('/paypal/initiate', [PaypalController::class, 'initiate'])->name('paypal.initiate');

require __DIR__.'/auth.php';
