import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
        './resources/js/**/*.jsx',
    ],

    theme: {
        extend: {
            colors: {
                primary: '#FF0000', // Red
                secondary: '#FFBF00', // Dark Yellow
                white: '#FFFFFF',
            },
            fontFamily: {
                sans: ['Josefin Sans', ...defaultTheme.fontFamily.sans],
            },
        },
    },

    plugins: [forms],
};
