<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;
use App\Models\User;
use App\Models\Product;

class CartControllerTest extends TestCase
{
    use RefreshDatabase;

    public function test_a_user_can_add_a_product_to_the_cart()
    {
        $this->withoutMiddleware();
        $user = User::factory()->create();
        $product = Product::factory()->create();

        $response = $this->actingAs($user)->post(route('cart.add'), [
            'item_id' => $product->id,
            'item_type' => 'product',
            'quantity' => 1,
        ]);

        $response->assertRedirect();
        $this->assertCount(1, session('cart'));
    }

    public function test_a_user_can_checkout()
    {
        $this->withoutMiddleware();
        $user = User::factory()->create();
        $product = Product::factory()->create();

        $this->withSession(['cart' => [
            'product-' . $product->id => [
                'item_id' => $product->id,
                'item_type' => 'product',
                'name' => $product->name,
                'price' => $product->price,
                'quantity' => 1,
            ]
        ]])->actingAs($user)->post(route('checkout.store'));

        $this->assertCount(1, Order::all());
    }
}
